//////////////////////////////////////////////
// TestUtils.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkDebugTests.TestUtils = class TestUtils extends nkDebug.TestClass
{
	static instance = new TestUtils ("nkDebugTests.testing") ;

	nkTests =
	{
		// Check
		CheckCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.check(true) ;
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("Check method threw on true.") ;
			}
		},
		CheckCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.check(false) ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("Check method did not throw on false.")
		},
		CheckCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.check(false, message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("Check method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("Check method did not throw on false.") ;
		},

		// AreNumbersEqual
		AreNumbersEqualCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.areNumbersEqual(0, 0) ;
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("areNumbersEqual method threw on true.") ;
			}
		},
		AreNumbersEqualCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areNumbersEqual(0, 1) ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("areNumbersEqual method did not throw on false.")
		},
		AreNumbersEqualCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areNumbersEqual(0, 1, 0, message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("areNumbersEqual method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("areNumbersEqual method did not throw on false.") ;
		},

		// AreNumbersEqual (precision)
		AreNumbersEqualPrecisionCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.areNumbersEqual(0.1, 0.2, 0.1) ;
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("areNumbersEqual method threw on true.") ;
			}
		},
		AreNumbersEqualPrecisionCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areNumbersEqual(0, 2, 0.5) ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("areNumbersEqual method did not throw on false.")
		},
		AreNumbersEqualPrecisionCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areNumbersEqual(0, 1, 0, message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("areNumbersEqual method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("areNumbersEqual method did not throw on false.") ;
		},

		// AreStringsEqual
		AreStringsEqualCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.areStringsEqual("foo", "foo") ;
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("areStringsEqual method threw on true.") ;
			}
		},
		AreStringsEqualCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areStringsEqual("foo", "bar") ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("areStringsEqual method did not throw on false.")
		},
		AreStringsEqualCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areStringsEqual("foo", "bar", message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("areStringsEqual method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("areStringsEqual method did not throw on false.") ;
		},

		// AreNumbersNotEqual
		AreNumbersNotEqualCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.areNumbersNotEqual(0, 1) ;
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("areNumbersNotEqual method threw on true.") ;
			}
		},
		AreNumbersNotEqualCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areNumbersNotEqual(0, 0) ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("areNumbersNotEqual method did not throw on false.")
		},
		AreNumbersNotEqualCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areNumbersNotEqual(0, 0, 0, message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("areNumbersNotEqual method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("areNumbersNotEqual method did not throw on false.") ;
		},

		// AreNumbersNotEqual (precision)
		AreNumbersNotEqualPrecisionCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.areNumbersNotEqual(0, 2, 0.5) ;
				
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("areNumbersNotEqual method threw on true.") ;
			}
		},
		AreNumbersNotEqualPrecisionCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areNumbersNotEqual(0.1, 0.2, 0.1) ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("areNumbersNotEqual method did not throw on false.")
		},
		AreNumbersNotEqualPrecisionCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areNumbersNotEqual(0.1, 0.2, 0.1, message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("areNumbersNotEqual method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("areNumbersNotEqual method did not throw on false.") ;
		},

		// AreStringsNotEqual
		AreStringsNotEqualCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.areStringsNotEqual("foo", "bar") ;
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("areStringsNotEqual method threw on true.") ;
			}
		},
		AreStringsNotEqualCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areStringsNotEqual("foo", "foo") ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("areStringsNotEqual method did not throw on false.")
		},
		AreStringsNotEqualCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.areStringsNotEqual("foo", "foo", message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("areStringsNotEqual method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("areStringsNotEqual method did not throw on false.") ;
		},

		// IsNull
		IsNullCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.isNull(null) ;
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("isNull method threw on true.") ;
			}
		},
		IsNullCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.isNull(0) ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("isNull method did not throw on false.")
		},
		IsNullCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.isNull(0, message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("isNull method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("isNull method did not throw on false.") ;
		},

		// IsNotNull
		IsNotNullCorrectReportOnTrue : function ()
		{
			try
			{
				nkDebug.TestUtils.isNotNull(0) ;
			}
			catch (e)
			{
				throw new nkDebug.TestRunException("isNotNull method threw on true.") ;
			}
		},
		IsNotNullCorrectReportOnFalse : function ()
		{
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.isNotNull(null) ;

				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, stop it from spreading
			}

			if (wrong)
				throw new nkDebug.TestRunException("isNotNull method did not throw on false.")
		},
		IsNotNullCorrectReportOnFalseWithMessage : function ()
		{
			// Check that everything is behaving in a sane way
			const message = "CustomMessage" ;
			var wrong = false ;

			try
			{
				nkDebug.TestUtils.isNotNull(null, message) ;

				// Reaching this code means the check did the opposite of what we wanted
				wrong = true ;
			}
			catch (e)
			{
				// Exactly what we need, check message to ensure all is right
				if (e.getRejectionReason() != message)
					throw new nkDebug.TestRunException("isNotNull method did not throw with the given message.") ;
			}

			if (wrong)
				throw new nkDebug.TestRunException("isNotNull method did not throw on false.") ;
		}
	}
}